﻿//////////////////////////////////////////////
// ClearTargetsPass.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "Pass.h"

#include "../Dll/DllDefines.h"

// nkMaths
#include <NilkinsMaths/Algebra/Vector.h>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ClearTargetsPass : public Pass
	{		
		public :

			// Getters
			nkMaths::Vector getClearColor () const ;
			unsigned int getColorTargetIndex () const ;
			float getClearDepthValue () const ;
			unsigned char getClearStencilValue () const ;
			bool getShouldClearColor () const ;
			bool getShouldClearDepth () const ;
			bool getShouldClearStencil () const ;

			// Setters
			void setClearColor (const nkMaths::Vector& value) ;
			void setColorTargetIndex (unsigned int value) ;
			void setClearDepthValue (float value) ;
			void setClearStencilValue (unsigned char value) ;
			void setShouldClearColor (bool value) ;
			void setShouldClearDepth (bool value) ;
			void setShouldClearStencil (bool value) ;

			// Import / Export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		protected :

			// Functions
			// Constructor
			ClearTargetsPass (System* system) noexcept ;

		protected :
		
			// Attributes
			// Color info
			nkMaths::Vector _clearColor ;
			unsigned int _colorTargetIndex ;

			// Depth info
			float _clearDepthValue ;
			unsigned char _clearStencilValue ;

			// Which to clean
			bool _shouldClearColor ;
			bool _shouldClearDepth ;
			bool _shouldClearStencil ;
	} ;
}